<?php
session_start();
include "../config/koneksi.php";

// PROTEKSI ADMIN
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

// STATISTIK
$totalEvent = mysqli_num_rows(mysqli_query($koneksi,"SELECT * FROM events"));
$totalOrder = mysqli_num_rows(mysqli_query($koneksi,"SELECT * FROM orders"));
$totalUser  = mysqli_num_rows(mysqli_query($koneksi,"SELECT * FROM users"));

// TOTAL PENDAPATAN
$qTotal = mysqli_query($koneksi,
    "SELECT SUM(total) AS total_uang FROM orders"
);
$totalUang = mysqli_fetch_assoc($qTotal);

// DATA CHART
$dataChart = mysqli_query($koneksi,
"SELECT events.nama_event, SUM(orders.jumlah) AS total
 FROM orders
 JOIN events ON orders.event_id = events.id
 GROUP BY events.id"
);

include "../layout/header.php";
?>

<h3 class="mb-4">Dashboard Admin</h3>

<div class="row">
<div class="col-md-4">
    <div class="card text-bg-primary mb-3">
        <div class="card-body">
            <h5>Total Event</h5>
            <h2><?= $totalEvent; ?></h2>
        </div>
    </div>
</div>

<div class="col-md-4">
    <div class="card text-bg-success mb-3">
        <div class="card-body">
            <h5>Total Pesanan</h5>
            <h2><?= $totalOrder; ?></h2>
        </div>
    </div>
</div>

<div class="col-md-4">
    <div class="card text-bg-warning mb-3">
        <div class="card-body">
            <h5>Total User</h5>
            <h2><?= $totalUser; ?></h2>
        </div>
    </div>
</div>
</div>
<div class="col-md-4">
    <div class="card text-bg-danger mb-3">
        <div class="card-body">
            <h5>Total Pendapatan</h5>
            <h2>
                Rp <?= number_format($totalUang['total_uang'] ?? 0); ?>
            </h2>
        </div>
    </div>
</div>
<br>

<a href="event.php" class="btn btn-dark">Kelola Event</a>
<a href="pesanan.php" class="btn btn-secondary">Data Pesanan</a>
<a href="laporan.php" class="btn btn-danger">Cetak Laporan PDF</a>
<a href="validasi.php?id=<?= $o['id']; ?>" 
   class="btn btn-success btn-sm"
   onclick="return confirm('Verifikasi tiket ini?')">
   Verifikasi
</a>
<a href="laporan_filter.php" class="btn btn-outline-danger">
    Laporan Berdasarkan Tanggal
</a>
<br><br>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<canvas id="chartPenjualan"></canvas>

<script>
const data = {
labels: [
<?php while($c=mysqli_fetch_assoc($dataChart)) echo "'".$c['nama_event']."',"; ?>
],
datasets: [{
    label: 'Tiket Terjual',
    data: [
    <?php mysqli_data_seek($dataChart,0);
    while($c=mysqli_fetch_assoc($dataChart)) echo $c['total'].","; ?>
    ]
}]
};

new Chart(document.getElementById('chartPenjualan'), {
type: 'bar',
data: data
});
</script>
<?php include "../layout/footer.php"; ?>