<?php
session_start();
include "../config/koneksi.php";
include "../layout/header.php";

// PROTEKSI ADMIN
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* =====================
   HAPUS EVENT
===================== */
if (isset($_GET['hapus'])) {
    $id = (int)$_GET['hapus'];
    mysqli_query($koneksi,"DELETE FROM events WHERE id=$id");
    echo "<div class='alert alert-success'>Event berhasil dihapus</div>";
}

/* =====================
   TAMBAH EVENT
===================== */
if (isset($_POST['simpan'])) {
    mysqli_query($koneksi,"
        INSERT INTO events (nama_event,tanggal,harga,kuota)
        VALUES (
            '$_POST[nama]',
            '$_POST[tanggal]',
            '$_POST[harga]',
            '$_POST[kuota]'
        )
    ");

    echo "<div class='alert alert-success'>Event berhasil ditambahkan</div>";
}

// AMBIL DATA EVENT
$qEvent = mysqli_query($koneksi,"SELECT * FROM events ORDER BY id DESC");
?>

<h3 class="mb-4">Kelola Event</h3>

<!-- FORM TAMBAH EVENT -->
<div class="card mb-4">
<div class="card-body">
<form method="post">
    <div class="mb-3">
        <label class="form-label">Nama Event</label>
        <input name="nama" class="form-control" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Tanggal</label>
        <input type="date" name="tanggal" class="form-control" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Harga</label>
        <input type="number" name="harga" class="form-control" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Kuota</label>
        <input type="number" name="kuota" class="form-control" required>
    </div>

    <button name="simpan" class="btn btn-primary">
        Simpan Event
    </button>
</form>
</div>
</div>

<!-- LIST EVENT -->
<h4>Daftar Event</h4>

<table class="table table-bordered table-striped mt-3">
<tr>
    <th>Nama Event</th>
    <th>Tanggal</th>
    <th>Harga</th>
    <th>Kuota</th>
    <th>Aksi</th>
</tr>

<?php if(mysqli_num_rows($qEvent) > 0): ?>
<?php while($e = mysqli_fetch_assoc($qEvent)): ?>
<tr>
    <td><?= $e['nama_event'] ?></td>
    <td><?= $e['tanggal'] ?></td>
    <td>Rp <?= number_format($e['harga']) ?></td>
    <td><?= $e['kuota'] ?></td>
    <td>
        <a href="?hapus=<?= $e['id'] ?>"
           class="btn btn-danger btn-sm"
           onclick="return confirm('Yakin hapus event ini?')">
           Hapus
        </a>
    </td>
</tr>
<?php endwhile; ?>
<?php else: ?>
<tr>
    <td colspan="5" class="text-center">Belum ada event</td>
</tr>
<?php endif; ?>
</table>

<?php include "../layout/footer.php"; ?>
