<?php
session_start();

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'user') {
    header("Location: ../auth/login.php");
    exit;
}

include "../config/koneksi.php";
include "../layout/header.php";

$user_id = $_SESSION['user']['id'];

/* =====================
   PAGINATION EVENT
===================== */
$limit = 6;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $limit;

$qEvent = mysqli_query($koneksi,"SELECT * FROM events LIMIT $start,$limit");
$qTotalEvent = mysqli_query($koneksi,"SELECT COUNT(*) AS total FROM events");
$totalEvent = mysqli_fetch_assoc($qTotalEvent)['total'];
$totalPage = ceil($totalEvent / $limit);

/* =====================
   HISTORY PEMBELIAN
===================== */
$qHistory = mysqli_query($koneksi,"
    SELECT orders.*, events.nama_event
    FROM orders
    JOIN events ON orders.event_id = events.id
    WHERE orders.user_id = $user_id
    ORDER BY orders.id DESC
");
?>

<h3 class="mb-4">Daftar Event</h3>

<div class="row">
<?php while($e = mysqli_fetch_assoc($qEvent)): ?>
<div class="col-md-4">
    <div class="card mb-3">
        <div class="card-body">
            <h5><?= $e['nama_event']; ?></h5>
            <p><?= $e['tanggal']; ?></p>
            <p>Rp <?= number_format($e['harga']); ?></p>
            <a href="pesan.php?id=<?= $e['id']; ?>" class="btn btn-primary w-100">
                Pesan Tiket
            </a>
        </div>
    </div>
</div>
<?php endwhile; ?>
</div>

<!-- PAGINATION -->
<nav>
<ul class="pagination justify-content-center">
<?php for($i=1; $i<=$totalPage; $i++): ?>
<li class="page-item <?= ($i==$page)?'active':'' ?>">
    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
</li>
<?php endfor; ?>
</ul>
</nav>

<hr class="my-5">

<h4>Riwayat Pembelian</h4>

<table class="table table-bordered table-striped mt-3">
<tr>
    <th>Event</th>
    <th>Jumlah</th>
    <th>Total</th>
    <th>Status</th>
    <th>Aksi</th>
</tr>

<?php if(mysqli_num_rows($qHistory) > 0): ?>
<?php while($h = mysqli_fetch_assoc($qHistory)): ?>
<tr>
    <td><?= $h['nama_event']; ?></td>
    <td><?= $h['jumlah']; ?></td>
    <td>Rp <?= number_format($h['total']); ?></td>
    <td>
        <?php if($h['status']=='paid'): ?>
            <span class="badge bg-success">PAID</span>
        <?php elseif($h['status']=='pending'): ?>
            <span class="badge bg-warning text-dark">PENDING</span>
        <?php elseif($h['status']=='used'): ?>
            <span class="badge bg-secondary">USED</span>
        <?php endif; ?>
    </td>
    <td>
        <?php if($h['status']=='paid'): ?>
            <a href="cetak_tiket.php?kode=<?= $h['kode_tiket']; ?>" 
               target="_blank" 
               class="btn btn-sm btn-primary">
               Cetak Tiket
            </a>
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
</tr>
<?php endwhile; ?>
<?php else: ?>
<tr>
    <td colspan="5" class="text-center">Belum ada pembelian</td>
</tr>
<?php endif; ?>
</table>


<?php include "../layout/footer.php"; ?>
