<?php
session_start();

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'user') {
    header("Location: ../auth/login.php");
    exit;
}

include "../config/koneksi.php";
include "../layout/header.php";

$id_event = (int)$_GET['id'];
$user_id  = $_SESSION['user']['id'];

$event = mysqli_fetch_assoc(
    mysqli_query($koneksi,"SELECT * FROM events WHERE id=$id_event")
);

if (isset($_POST['pesan'])) {
    $jumlah  = (int)$_POST['jumlah'];
    $payment = $_POST['payment_method'];

    if ($jumlah > $event['kuota']) {
        $error = "Kuota tidak mencukupi";
    } else {
        $total   = $jumlah * $event['harga'];
        $invoice = "INV".time().rand(100,999);
        $kode_tiket = "TKT".time().rand(100,999);

        mysqli_query($koneksi,"
            INSERT INTO orders 
            (user_id,event_id,jumlah,invoice,kode_tiket,total,payment_method,status)
            VALUES 
            ('$user_id','$id_event','$jumlah','$invoice','$kode_tiket','$total','$payment','pending')
        ");

        // kurangi kuota
        mysqli_query($koneksi,"
            UPDATE events SET kuota = kuota - $jumlah
            WHERE id = $id_event
        ");

        header("Location: payment.php?invoice=$invoice");
        exit;
    }
}
?>

<h3><?= $event['nama_event']; ?></h3>
<p>Tanggal: <?= $event['tanggal']; ?></p>
<p>Harga: Rp <?= number_format($event['harga']); ?></p>
<p>Sisa Kuota: <?= $event['kuota']; ?></p>

<?php if(isset($error)): ?>
<div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<form method="post">
    <div class="mb-3">
        <label>Jumlah Tiket</label>
        <input type="number" name="jumlah" min="1" class="form-control" required>
    </div>

    <div class="mb-3">
        <label>Metode Pembayaran</label>
        <select name="payment_method" class="form-control" required>
            <option value="">-- Pilih --</option>
            <option value="transfer">Transfer Bank</option>
            <option value="qris">QRIS</option>
        </select>
    </div>

    <button name="pesan" class="btn btn-primary w-100">
        Pesan & Bayar
    </button>
</form>

<?php include "../layout/footer.php"; ?>
